clear all, clc

%add folder path and filename
myfolder='/Users/jakobrentsch/FU Box/Papers/Stripes/figure S1/FLUOSIM';
output_folder = '/Users/jakobrentsch/FU Box/Papers/Stripes/JCB/Resubmission/Data/Scripts and raw data/Figure 5/c';
filename='SRI_screen_capture_rep';
autocutoff=0.15;


pixelsize=10; %in nm

file_list = dir(myfolder);
cell = struct2cell(file_list);
num_images = length(cell(1,:));

autocorr_array = nan(10,10);


for  m=1:1:length(file_list)
    
    curr_folder = [myfolder, '/' , file_list(m).name];
    
    plot_profile_array=zeros(231, 12)
    
    
    for n=0:1:9
        
        if contains(file_list(m).name,'cp') == 1
            
            im_name = [curr_folder, '/', filename, num2str(n), '.tiff'];
            
            im = imread(im_name);
            
            roi = im(95:155, 95:325);
            
            
            plot_profile = [(1:length(mean(roi)))', (mean(roi))'];
            
            plot_profile_array(:,1) = (1:length(mean(roi)))';
            plot_profile_array(:,m+2) = mean(roi)';
            
            
            auto=autocorr(plot_profile(:,2),length(plot_profile)-1);
            
            peak=mean(auto(20));
            
            autocorr_array(m,n+1) = peak 
            
            
            figure(m)
            plot([1:length(auto)]'*pixelsize,auto(:,1));
            
            set(gca,'FontSize', 15)     
            xlabel('Lag (nm)');
            ylabel('ACF (a.u.)');
            ylim([-0.5, 1])
            xlim([0,1000])
            xticks(0:200:1000)
            title({'Autocorrelation of simulated SPT'},'FontWeight','Normal');
            
            set(gca,'FontSize', 15)
            
            hold on
            
        end
 
    end
    
          hold off
        
          %save figure to path
                  if contains(file_list(m).name,'cp') == 1

            saveas(figure(m),fullfile(output_folder,[filename,'_', file_list(m).name, '_','ACF-lag[nm]-plot','.png']))
            saveas(figure(m),fullfile(output_folder,[filename,'_', file_list(m).name, '_','ACF-lag[nm]-plot','.fig']))
            saveas(figure(m),fullfile(output_folder,[filename,'_', file_list(m).name, '_','ACF-lag[nm]-plot','.pdf']))
                  end
end

writematrix(autocorr_array, [output_folder, '/cp_array.csv'])